# 피보나치 수

수학에서, 일반적으로 $F(n)$으로 표기하는 피보나치 수는 첫째 및 둘째 항이 1이며 그 뒤의 모든 항은 바로 앞 두 항의 합인 피보나치 수열을 구성한다.

`[0, 1, 1, 2, 3, 5, 8, 13, 21, 34, ...]`

## 활용

`N번째 피보나치 수`를 구하는 것은 다양하게 활용될 수 있다:

- 최근 피보나치 수열과 황금비는 고에너지 물리학, 양자역학, 암호학, 코딩 등 다양한 과학 분야의 연구자들에게 큰 관심을 받고 있다.

## 절차

1. 기본 행렬을 준비한다.
2. 기본 행렬의 거듭제곱을 계산한다.
3. 행렬의 원소 중 필요한 값을 찾는다.

## 예시

`8번째` 피보나치 수를 구하라.

### 0단계

```
| F(n+1)  F(n)  |
| F(n)    F(n-1)|
```

### 1단계

```
기본 행렬
| 1 1 |
| 1 0 |
```

### 2단계

```
기본 행렬의 제곱
| 2 1 |
| 1 1 |
```

### 3단계

```
기본 행렬의 네제곱
| 5 3 |
| 3 2 |
```

### 4단계

```
기본 행렬의 여덟제곱
| 34 21 |
| 21 13 |
```

### 5단계

```
F(8) = 21
```

## 구현

- [C++](https://github.com/TheAlgorithms/C-Plus-Plus/blob/master/math/fibonacci.cpp)
- [Java](https://github.com/TheAlgorithms/Java/blob/master/src/main/java/com/thealgorithms/maths/FibonacciNumber.java)
- [Javascript](https://github.com/TheAlgorithms/Javascript/blob/80c2dc85d714f73783f133964d6acd9b5625ddd9/Maths/Fibonacci.js)
- [Python](https://github.com/TheAlgorithms/Python/blob/master/maths/fibonacci.py)

## 영상 URL

- [Gaurav Sen](https://www.youtube.com/watch?v=EEb6JP3NXBI)

## 기타

- [증명](https://brilliant.org/wiki/fast-fibonacci-transform/)
